// 负责接收图片URL并通过 chrome.downloads 下载
chrome.runtime.onMessage.addListener(async (msg, sender, sendResponse) => {
  if (msg.type === "DOWNLOAD_IMAGES") {
    const { images, prefix } = msg.payload || {};
    if (!Array.isArray(images) || images.length === 0) {
      sendResponse({ ok: false, error: "No images to download." });
      return true;
    }

    // 去重 & 过滤非法
    const unique = Array.from(new Set(
      images
        .filter(Boolean)
        .map(u => u.trim())
    ));

    const ts = new Date().toISOString().slice(0,19).replace(/[:T]/g, "-");
    const base = prefix || `taobao-${ts}`;

    for (let i = 0; i < unique.length; i++) {
      const url = normalizeURL(unique[i]);
      // 推断扩展名
      const ext = guessExt(url);
      const filename = `${base}/${String(i + 1).padStart(3, "0")}${ext}`;
      try {
        await chrome.downloads.download({
          url,
          filename,
          conflictAction: "uniquify",
          saveAs: false
        });
      } catch (e) {
        console.warn("Download failed:", url, e);
      }
    }
    sendResponse({ ok: true, count: unique.length });
    return true;
  }
});

// 规范化 URL：处理协议、去掉缩略尾巴
function normalizeURL(u) {
  let url = u;

  // 补协议
  if (url.startsWith("//")) url = "https:" + url;

  // 淘系常见缩略参数（_100x100, _120x120, _800x800 等）
  url = url.replace(/_(\d+x\d+)\.jpg$/i, ".jpg")
           .replace(/_(\d+x\d+)\.png$/i, ".png")
           .replace(/_(\d+x\d+)\.webp$/i, ".webp");

  // 去掉质量参数类似 q90.jpg_.webp
  url = url.replace(/\.jpg_.*$/i, ".jpg")
           .replace(/\.png_.*$/i, ".png")
           .replace(/\.webp_.*$/i, ".webp");

  // 移除常见缩略 query
  try {
    const uo = new URL(url);
    // 可根据需要保留参数，这里先清空以拿原图
    uo.search = "";
    return uo.toString();
  } catch {
    return url;
  }
}

function guessExt(url) {
  const lower = url.toLowerCase();
  if (lower.includes(".webp")) return ".webp";
  if (lower.includes(".png")) return ".png";
  if (lower.includes(".jpeg")) return ".jpeg";
  if (lower.includes(".jpg")) return ".jpg";
  // 有些 URL 无扩展名，默认 jpg
  return ".jpg";
}
